/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.undo.parser;

import io.seata.common.executor.Initialize;
import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.common.loader.EnhancedServiceNotFoundException;
import io.seata.common.loader.LoadLevel;
import io.seata.common.util.CollectionUtils;
import io.seata.rm.datasource.undo.BranchUndoLog;
import io.seata.rm.datasource.undo.UndoLogParser;
import io.seata.rm.datasource.undo.parser.FstSerializerFactory;
import io.seata.rm.datasource.undo.parser.spi.FstSerializer;
import java.util.Collection;
import java.util.List;
import org.nustaq.serialization.FSTObjectSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="fst")
public class FstUndoLogParser
implements UndoLogParser,
Initialize {
    private static final Logger LOGGER = LoggerFactory.getLogger(FstUndoLogParser.class);
    public static final String NAME = "fst";
    private FstSerializerFactory fstFactory = FstSerializerFactory.getDefaultFactory();

    public void init() {
        try {
            List serializers = EnhancedServiceLoader.loadAll(FstSerializer.class);
            if (CollectionUtils.isNotEmpty((Collection)serializers)) {
                for (FstSerializer serializer : serializers) {
                    if (serializer == null) continue;
                    Class type = serializer.type();
                    FSTObjectSerializer ser = serializer.ser();
                    boolean alsoForAllSubclasses = serializer.alsoForAllSubclasses();
                    if (type == null || ser == null) continue;
                    this.fstFactory.registerSerializer(type, ser, alsoForAllSubclasses);
                    LOGGER.info("fst undo log parser load [{}].", (Object)serializer.getClass().getName());
                }
            }
        }
        catch (EnhancedServiceNotFoundException e) {
            LOGGER.warn("FstSerializer not found children class.", (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte[] getDefaultContent() {
        return this.fstFactory.serialize(new BranchUndoLog());
    }

    @Override
    public byte[] encode(BranchUndoLog branchUndoLog) {
        return this.fstFactory.serialize(branchUndoLog);
    }

    @Override
    public BranchUndoLog decode(byte[] bytes) {
        return (BranchUndoLog)this.fstFactory.deserialize(bytes);
    }
}

